IF EXISTS
(
    SELECT *
    FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[dbo].[P_TRILHO_MAQ_EXCESSO]')
          AND type IN(N'P', N'PC')
)
    DROP PROCEDURE [dbo].[P_TRILHO_MAQ_EXCESSO];
GO
SET ANSI_NULLS ON;
GO
SET QUOTED_IDENTIFIER ON;
GO

--EXECUTE [P_TRILHO_MAQ_EXCESSO] 1,1,1
/*
=======================================================================================
'Job.................: Linx - Trilho de envio de excesso 
'Função..............: 
'Objetivo............: 
'Tabelas.............: 
'Dt Modificação......: 08/04/2021
'Modificação.........: Tag #A001 DISTINCT CD_FILIAL para evitar erro de PK
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/

CREATE PROCEDURE [dbo].[P_TRILHO_MAQ_EXCESSO](@CD_EMP      INT = 1,
                                              @CD_CTR_DEPO INT = 1,
                                              @CD_MAQ      INT)
WITH ENCRYPTION
AS
set nocount on;    
	print 'Processando Maq	  .: ' + convert(varchar(50),@cd_maq)
	print '		    Depos.: ' + convert(varchar(50),@CD_CTR_DEPO)

     --Versao 2395
     DELETE FROM TRILHO_MAQ_EXCESSO
     WHERE CD_EMP = @CD_EMP
           AND CD_EXCESSO_MAQ = @CD_MAQ
           AND CD_CTR_DEPO = @CD_CTR_DEPO;

	declare @CdFilial int=0
	declare c_FilTrilho  CURSOR FAST_FORWARD FOR
		SELECT DISTINCT CD_FILIAL
			FROM UFD_TRILHO_EXCESSO_RET_FILIAL(@CD_MAQ)

	OPEN c_FilTrilho
	FETCH NEXT FROM c_FilTrilho INTO @CdFilial
	WHILE @@FETCH_STATUS = 0
		BEGIN
			PRINT 'Procesando lj ' + CONVERT(VARCHAR, @CdFilial) + ' Time ' +convert(varchar, getdate(),108) ;
			INSERT INTO TRILHO_MAQ_EXCESSO(DT_MOV, CD_EXCESSO_MAQ, CD_EMP, CD_CTR_DEPO, CD_FILIAL
									, CD_PROD, DS_PROD, DS_ARV_MERC_LINHA, ESEG, EMAX
									, QTDE_FACEAMENTO, QTDE_FINANCIADO, QTDE_LIMITADOR, VLR_EXCESSO
									, MEDIAF, COBERTURA, QT_EST, QTDE_EMAX, EXCESSO, VLR_CUSTO )
            SELECT DBO.F_HOJE() DT_MOV
                 , @CD_MAQ
                 , C.CD_EMP
                 , @CD_CTR_DEPO
                 , C.CD_FILIAL
                 , C.CD_PROD
                 , C.DS_PROD
                 , C.DS_ARV_MERC_LINHA
                 , C.ESEG
                 , (CASE
                        WHEN CONFIG.FLAG_DIAS_ACIMA_EMAX = 1
                        THEN(C.EMAX + SM.QTDE_P_EXCESSO)
                        ELSE(CASE
                                 WHEN SM.QTDE_P_EXCESSO > EMAX
                                 THEN SM.QTDE_P_EXCESSO
                                 ELSE C.EMAX
                             END)
                    END) AS EMAX
                 , C.QTDE_FACEAMENTO
                 , C.QTDE_FINANCIADO
                 , C.QTDE_LIMITADOR
                 ,isnull( CONVERT( MONEY, ROUND(ROUND(C.QT_EST_ATU - ROUND(dbo.UFD_EST_AJUSTA_EMAX_GARANTIA
                                                                   ((CASE
                                                                         WHEN CONFIG.FACE_FINANCIADO = 1
                                                                         THEN C.QTDE_FACEAMENTO
                                                                         ELSE 0
                                                                     END), GETDATE() + 1, (CASE
                                                                                               WHEN CONFIG.FACE_FINANCIADO = 1
                                                                                               THEN C.QTDE_FINANCIADO
                                                                                               ELSE 0
                                                                                           END), C.QTDE_LIMITADOR, ROUND((C.MEDIAF / 30.0000) * (CASE
                                                                                                                                                     WHEN CONFIG.FLAG_DIAS_ACIMA_EMAX = 1
                                                                                                                                                     THEN(C.EMAX + SM.QTDE_P_EXCESSO)
                                                                                                                                                     ELSE(CASE
                                                                                                                                                              WHEN SM.QTDE_P_EXCESSO > EMAX
                                                                                                                                                              THEN SM.QTDE_P_EXCESSO
                                                                                                                                                              ELSE C.EMAX
                                                                                                                                                          END)
                                                                                                                                                 END), 0), QTDE_PROD_GARANTIR
                                                                   ), 0), 0) / (CASE
                                                                                    WHEN CONFIG.FLAG_UND_RESSUP = 1
                                                                                    THEN(CASE
                                                                                             WHEN P.QT_UNI_RESSUPRIMENTO = 0
                                                                                             THEN 1
                                                                                             ELSE P.QT_UNI_RESSUPRIMENTO
                                                                                         END)
                                                                                    ELSE 1
                                                                                END), 0, 1) * (CASE
                                                                                                   WHEN CONFIG.FLAG_UND_RESSUP = 1
                                                                                                   THEN(CASE
                                                                                                            WHEN P.QT_UNI_RESSUPRIMENTO = 0
                                                                                                            THEN 1
                                                                                                            ELSE P.QT_UNI_RESSUPRIMENTO
                                                                                                        END)
                                                                                                   ELSE 1
                                                                                               END) * C.VLR_TABELA) ,0) VLR_EXCESSO
                 , C.MEDIAF
                 , CASE
                       WHEN C.MEDIAF > 0
                       THEN CONVERT(    MONEY, (C.QT_EST_ATU / C.MEDIAF) * 30)
                       ELSE CONVERT(MONEY, (C.QT_EST_ATU / 0.001) * 30)
                   END COBERTURA
                 , C.QT_EST_ATU
                 , CONVERT( MONEY, ROUND((C.MEDIAF / 30.0) * (CASE
                                                                  WHEN CONFIG.FLAG_DIAS_ACIMA_EMAX = 1
                                                                  THEN(C.EMAX + SM.QTDE_P_EXCESSO)
                                                                  ELSE(CASE
                                                                           WHEN SM.QTDE_P_EXCESSO > EMAX
                                                                           THEN SM.QTDE_P_EXCESSO
                                                                           ELSE C.EMAX
                                                                       END)
                                                              END), 0)) QTDE_EMAX

                 , isnull(CONVERT( MONEY, ROUND(ROUND(C.QT_EST_ATU - ROUND(dbo.UFD_EST_AJUSTA_EMAX_GARANTIA
                                                                   ((CASE
                                                                         WHEN CONFIG.FACE_FINANCIADO = 1
                                                                         THEN C.QTDE_FACEAMENTO
                                                                         ELSE 0
                                                                     END), GETDATE() + 1, (CASE
                                                                                               WHEN CONFIG.FACE_FINANCIADO = 1
                                                                                               THEN C.QTDE_FINANCIADO
                                                                                               ELSE 0
                                                                                           END), C.QTDE_LIMITADOR, ROUND((C.MEDIAF / 30.0000) * (CASE
                                                                                                                                                     WHEN CONFIG.FLAG_DIAS_ACIMA_EMAX = 1
                                                                                                                                                     THEN(C.EMAX + SM.QTDE_P_EXCESSO)
                                                                                                                                                     ELSE(CASE
                                                                                                                                                              WHEN SM.QTDE_P_EXCESSO > EMAX
                                                                                                                                                              THEN SM.QTDE_P_EXCESSO
                                                                                                                                                              ELSE C.EMAX
                                                                                                                                                          END)
                                                                                                                                                 END), 0), case when QTDE_PROD_GARANTIR>0 then QTDE_PROD_GARANTIR 
																																when c.mediaf>0 then 1
																																else 0 end
                                                                   ), 0), 0) / (CASE
                                                                                    WHEN CONFIG.FLAG_UND_RESSUP = 1
                                                                                    THEN(CASE
                                                                                             WHEN P.QT_UNI_RESSUPRIMENTO = 0
                                                                                             THEN 1
                                                                                             ELSE P.QT_UNI_RESSUPRIMENTO
                                                                                         END)
                                                                                    ELSE 1
                                                                                END), 0, 1) * (CASE
                                                                                                   WHEN CONFIG.FLAG_UND_RESSUP = 1
                                                                                                   THEN(CASE
                                                                                                            WHEN P.QT_UNI_RESSUPRIMENTO = 0
                                                                                                            THEN 1
                                                                                                            ELSE P.QT_UNI_RESSUPRIMENTO
                                                                                                        END)
                                                                                                   ELSE 1
                                                                                               END)),0) AS EXCESSO
                 , C.VLR_CUSTO
            FROM
                 TRILHO_PROD_EXCESSO C
                 INNER JOIN(SELECT CD_EMP
									 , CD_EXCESSO_MAQ
									 , FACE_FINANCIADO
									 , QTDE_PROD_GARANTIR
									 , MES_VIDA_PARAM
									 , MES_VIDA_QTDE
									 , ISNULL(NAO_ENVIA_PROD_SNGPC, 0) NAO_ENVIA_PROD_SNGPC
									 , ISNULL(FLAG_DIAS_ACIMA_EMAX, 0) FLAG_DIAS_ACIMA_EMAX
									 , ISNULL(FLAG_UND_RESSUP, 0) FLAG_UND_RESSUP
									 , ISNULL(FLAG_PROD_DEFINIDO, 0) AS FLAG_PROD_DEFINIDO
									 , ISNULL(NAO_ENVIAR_TERMOLABEL, 0) AS NAO_ENVIAR_TERMOLABEL
								FROM EST_EXCESSO_MAQ
								WHERE CD_EMP = @CD_EMP
									  AND CD_EXCESSO_MAQ = @CD_MAQ) CONFIG ON 
					C.CD_EMP = CONFIG.CD_EMP
                 INNER JOIN EST_PROD P ON 
					C.CD_EMP = P.CD_EMP
                    AND C.CD_PROD = P.CD_PROD --SELECIONA OS CURVAS DA MAQUINA	
                 INNER JOIN EST_EXCESSO_MAQ_EST_PROD_CURVA_SIGLA SM ON 
					CONFIG.CD_EXCESSO_MAQ = SM.CD_EXCESSO_MAQ
                    AND C.CD_EMP = SM.CD_EMP
                    AND C.CD_SIGLA = SM.CD_SIGLA

            WHERE 
				C.CD_EMP = @CD_EMP
                  AND C.CD_CTR_DEPO = @CD_CTR_DEPO
                  AND ((--SELECIONA AS LINHAS DA MAQUINA
                       EXISTS
                       (
                           SELECT LM.CD_EMP
                           FROM EST_EXCESSO_MAQ_EST_ARV_MERC_LINHA LM
                           WHERE C.CD_EMP = LM.CD_EMP
                                 AND C.CD_ARV_MERC_LINHA = LM.CD_ARV_MERC_LINHA
                                 AND CONFIG.CD_EXCESSO_MAQ = LM.CD_EXCESSO_MAQ
                                 AND CONFIG.FLAG_PROD_DEFINIDO = 0
                       )
					AND --SELECIONA OS FABRICANTES DA MAQUINA				 
					EXISTS(SELECT FM.CD_EMP
								FROM EST_EXCESSO_MAQ_EST_PROD_FABRIC FM
								WHERE C.CD_EMP = FM.CD_EMP
										AND C.CD_FABRIC = FM.CD_FABRIC
										AND CONFIG.CD_EXCESSO_MAQ = FM.CD_EXCESSO_MAQ
										AND CONFIG.FLAG_PROD_DEFINIDO = 0
							)
						)
                    OR --SELECIONA OS PRODUTOS DA MAQUINA
                    EXISTS
                      (SELECT MP.CD_EMP
                          FROM EST_PROD_EST_EXCESSO_MAQ MP
                          WHERE C.CD_EMP = MP.CD_EMP
                                AND C.CD_PROD = MP.CD_PROD
                                AND CONFIG.CD_EXCESSO_MAQ = MP.CD_EXCESSO_MAQ
                                AND CONFIG.FLAG_PROD_DEFINIDO = 1
                      ))
                  ------------------------------------------ CONFIGURACOES DA MAQUINA -------------------------------------------------
                  -- QTDE PRODUTOS A GARANTIR DE ACORDO COM A CONFIGURACAO DA MAQUINA
                  AND C.QT_EST_ATU > CONFIG.QTDE_PROD_GARANTIR 

			      --Produtos controlados
                  AND (CASE
                           WHEN CONFIG.NAO_ENVIA_PROD_SNGPC = 1
                           THEN ISNULL(P.CONTROLE_SNGPC, 0)
                           ELSE 0
                       END) = 0

                  --Produtos controlados
                  AND (CASE
                           WHEN CONFIG.NAO_ENVIAR_TERMOLABEL = 1
                           THEN ISNULL(P.TERMO_LABEL, 0)
                           ELSE 0
                       END) = 0
					
                  -- MESES DE VIDA DO PRODUTO DE ACORDO COM A CONFIGURACAO DA MAQUINA
                  AND (CONFIG.MES_VIDA_PARAM = 1
                       AND C.QTDE_MES_VENDA_FECHADO > MES_VIDA_QTDE
                       OR CONFIG.MES_VIDA_PARAM = 2
                       AND C.QTDE_MES_VENDA_FECHADO < MES_VIDA_QTDE
                       OR CONFIG.MES_VIDA_PARAM = 0)

                  --SELECIONA AS FILIAIS AGENDADAS PARA O DIA NOS TRILHOS DA MAQUINA	
                  AND C.CD_FILIAL =@CdFilial
	  
		FETCH NEXT FROM c_FilTrilho INTO @CdFilial
	END

	CLOSE c_FilTrilho;
	DEALLOCATE c_FilTrilho; 
    --------------------------------------------------------------------------------------------------------------------
    DELETE FROM TRILHO_MAQ_EXCESSO
    WHERE CD_EXCESSO_MAQ = @CD_MAQ
        AND (DT_MOV = DBO.F_HOJE()
            OR DATEDIFF(DAY, DT_MOV, GETDATE()) > 15)
        AND (EXCESSO < 1)
        AND CD_CTR_DEPO = @CD_CTR_DEPO;
GO